package com.example.sefinsa_app.ui.clientes;

import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.recyclerview.widget.RecyclerView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.navigation.NavController;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.ClientesWorker;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.NetworkSpeedChecker;
import com.example.sefinsa_app.PagosWorker;
import com.example.sefinsa_app.PrestamosWorker;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.prestamos.PrestamosFragment;
import com.example.sefinsa_app.utilities.ClientesAdapter;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClientesFragment extends Fragment implements NetworkChangeReceiver.NetworkChangeListener {

    private ClientesViewModel mViewModel;
    public static ArrayList<Cliente> clientes, clientesFiltrados;
    private VolleyS vs;
    private RequestQueue requestQueue;

    public static SearchView svClientes;
    private static ShimmerFrameLayout shimmer;
    private static RecyclerView recyclerView;
    public static ClientesAdapter clientesAdapter;
    private LinearLayoutManager linearLayoutManager;
    private FloatingActionButton fabCrearCliente;

    private SharedPreferences sesion;

    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private static ProgressDialog dialog;
    private ArrayList<Ruta> rutas;
    private ArrayList<Poblacion> poblaciones;
    private ArrayList<Colocadora> colocadoras;
    private NetworkChangeReceiver networkChangeReceiver;
    private TextView textViewMensajes;
    private NetworkSpeedChecker speedChecker;
    private boolean isConnected = true;
    private static boolean isShimmerActive = false;
    private int retryCount = 0; // Contador de reintentos
    private static final int MAX_RETRIES = 80; // Máximo de reintentos
    public static ClientesFragment newInstance() {
        return new ClientesFragment();
    }
    private static final int BATCH_SIZE = 10; // Número de registros a cargar por cada petición
    private int offset = 0; // Offset inicial
    private boolean isLoading = false; // Para evitar múltiples peticiones simultáneas
    private static boolean isFiltering = false;  // Bandera para saber si se está filtrando

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {

        setHasOptionsMenu(true);
        requireActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
        networkChangeReceiver = new NetworkChangeReceiver(this);
        return inflater.inflate(R.layout.fragment_clientes, container, false);
    }
    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (svClientes != null)
            svClientes.setQuery("", false);
    }
    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }
    public static void startShimmer() {
        if (shimmer != null) { // Verificar que la referencia no sea nula
            shimmer.startShimmer();
            shimmer.setVisibility(View.VISIBLE); // Asegurarte de que sea visible
            isShimmerActive = true; // Marcar que el shimmer está activo
        }
    }

    public static void stopShimmer() {
        if (shimmer != null) { // Verificar que la referencia no sea nula
            shimmer.stopShimmer();
            shimmer.setVisibility(View.GONE); // Asegurarte de que sea visible
            isShimmerActive = false; // Marcar que el shimmer está activo
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        super.onCreate(savedInstanceState);
        Log.e("ClientesFragment", "SE ABRIO EL CLIENTES FRAGMENT.......................... ");
        textViewMensajes = requireActivity().findViewById(R.id.message_text);
        // Inicializar la cola de solicitudes (request queue)
        vs = VolleyS.getInstance(requireContext());  // O getContext() dependiendo del API level
        requestQueue = vs.getRequestQueue();
        CurrentFragment.fragment = "ClientesFragment";
        retryCount = 0;
        sesion = requireActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);

        rutaController = new RutaController(requireActivity());
        poblacionController = new PoblacionController(requireActivity());
        colocadoraController = new ColocadoraController(requireActivity());
        clienteController = new ClienteController(requireActivity());

        rutas = new ArrayList<>();
        poblaciones = new ArrayList<>();
        colocadoras = new ArrayList<>();
        clientes = new ArrayList<>();

        getRutas();
        getPoblaciones();

        if (rutaController.tablaExiste() && poblacionController.tablaExiste()) {
            getColocadoras();
        }
        FragmentManager fm = requireActivity().getSupportFragmentManager();
        for (int i = 0; i < fm.getBackStackEntryCount(); ++i) {
            fm.popBackStack();
        }

        shimmer = view.findViewById(R.id.sfClientes);

        recyclerView = view.findViewById(R.id.rvClientes);
        svClientes = view.findViewById(R.id.svClientes);
        fabCrearCliente = view.findViewById(R.id.fabCrearCliente);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);

                if (isFiltering) {
                    return;
                }

                LinearLayoutManager layoutManager = (LinearLayoutManager) recyclerView.getLayoutManager();
                if (layoutManager != null && !isLoading) {
                    int visibleItemCount = layoutManager.getChildCount();
                    int totalItemCount = layoutManager.getItemCount();
                    int pastVisibleItems = layoutManager.findFirstVisibleItemPosition();

                    int preloadMargin = 5;  // Número de elementos antes de llegar al final

                    if ((visibleItemCount + pastVisibleItems) >= (totalItemCount - preloadMargin)) {
                        recyclerView.post(() -> {
                            loadMoreClientes();
                        });
                    }
                }
            }
        });

        if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                || sesion.getString("nombre_perfil", "").equals("GESTOR") ) {
            fabCrearCliente.setVisibility(View.INVISIBLE);
        } else {
            fabCrearCliente.setOnClickListener(view1 -> {
                Bundle bundle = new Bundle();
                bundle.putSerializable("clientes", clientes);

                Navigation.findNavController(requireActivity(), R.id.nav_host_fragment_content_dashboard)
                        .navigate(R.id.nav_clientes_crear, bundle);
            });
        }

            linearLayoutManager = new LinearLayoutManager(getContext());
            recyclerView.setLayoutManager(linearLayoutManager);


            clientesAdapter = new ClientesAdapter(requireActivity(), new ArrayList<>());
            recyclerView.setAdapter(clientesAdapter);


        if (!isAdded() || getContext() == null) {
            Log.e("ClientesFragment", "El fragmento no está listo. Operación abortada onResume.");
            return;
        }


        clientes.clear();
    }
    @Override
    public void onResume() {
        super.onResume();
        CurrentFragment.fragment = "ClientesFragment"; // Cambia según el Fragment.
    }
    @Override
    public void onDestroy() {
        super.onDestroy();
        if (speedChecker != null) {
            speedChecker.stopChecking();
        }
    }
    public void logLastFiveClientes(SQLiteDatabase db) {
        String query = "SELECT c.id, c.nombre_completo, c.aval_id, a.nombre_completo AS aval_nombre, c.updated_at, c.update_comprobantes, c.update_garantias " +
                "FROM clientes c " +
                "LEFT JOIN avales a ON c.aval_id = a.id " +
                "ORDER BY c.updated_at DESC " +
                "LIMIT 5";

        Cursor cursor = db.rawQuery(query, null);

        if (cursor.moveToFirst()) {
            do {
                int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String aval_id = cursor.getString(cursor.getColumnIndexOrThrow("aval_id"));
                String avalNombre = cursor.getString(cursor.getColumnIndexOrThrow("aval_nombre"));
                String updated_at = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
                String update_comprobantes = cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes"));
                String update_garantias = cursor.getString(cursor.getColumnIndexOrThrow("update_garantias"));

                Log.d("ClientesWorker", "DATOS EN CONSULTA SQL: ID: " + id + " | Nombre: " + nombre + " | Aval_id: " + aval_id + " | Aval Nombre: " + avalNombre + " | updated_at: " + updated_at + " | update_comprobantes: " + update_comprobantes + " | update_garantias: " + update_garantias);
            } while (cursor.moveToNext());
        } else {
            Log.d("ClientesWorker", "No hay registros en la tabla de clientes.");
        }

        cursor.close(); // Cerramos el Cursor después de usarlo
    }

    public void logLastFiveAvales(SQLiteDatabase db) {
        String query = "SELECT * FROM avales ORDER BY id DESC LIMIT 5";
        Cursor cursor = db.rawQuery(query, null);

        if (cursor.moveToFirst()) {
            do {
                int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String updated_at = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));

                Log.d("AvalesWorker", "AvalesWorker ID: " + id + " | Nombre: " + nombre + " | updated_at: " + updated_at);
            } while (cursor.moveToNext());
        } else {
            Log.d("AvalesWorker", "No hay registros en la tabla de avales.");
        }

        cursor.close(); // Cerramos el Cursor después de usarlo
    }

    @Override
    public void onStart() {
        super.onStart();

        DatabaseHelper dbHelper = new DatabaseHelper(getContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase(); // Asegúrate de tener una instancia de tu DbHelper

        //logLastFiveAvales(db);
        //logLastFiveClientes(db);

        db.close();
        IntentFilter filter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
        requireActivity().registerReceiver(networkChangeReceiver, filter);
        if (speedChecker != null) {
            speedChecker.startChecking();
        }

        dialog = new ProgressDialog(requireActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        startShimmer();
        if (isNetworkAvailable()) {
            isTableEmpty("prestamos", new IsTableEmptyCallback() {
                @Override
                public void onResult(boolean isEmpty) {
                    if (isEmpty) {
                        Log.d("PRESTAMOS", "PRESTAMOS ESTÁ VACÍA. Ejecutando PrestamosWorker FULL...");
                        PrestamosWorker.allDataLoadedPrestamos = false;
                        PrestamosWorker.currentPagePrestamos = 0;
                        PrestamosWorker.isTaskPrestamosCompleted = false;
                        PrestamosWorker.enqueueWork(requireContext());
                    } else {
                        Log.d("PRESTAMOS", "PRESTAMOS NO ESTÁ VACÍA. Ejecutando PrestamosWorker UPDATE...");
                        PrestamosWorker.allDataLoadedPrestamos = true;
                        PrestamosWorker.currentPagePrestamos = 0;
                        PrestamosWorker.isTaskPrestamosCompleted = true;
                        //PrestamosWorker.enqueueWork(requireContext());
                    }
                    checckBanderaPrestamos();
                }
            });
        } else {
            ClientesWorker.isTaskClientesCompleted = true;
            AvalesWorker.isTaskAvalesCompleted = true;
            PrestamosWorker.isTaskPrestamosCompleted = true;

            cargarClientesDesdeSQLite(offset, BATCH_SIZE);
        }
        svClientes.setOnQueryTextListener(new SearchView.OnQueryTextListener() {
            @Override
            public boolean onQueryTextSubmit(String query) {
                filtrarClientes(query);
                return false;
            }

            @Override
            public boolean onQueryTextChange(String newText) {
                filtrarClientes(newText);
                return false;
            }
        });
    }

    @Override
    public void onStop() {
        super.onStop();
        requireActivity().unregisterReceiver(networkChangeReceiver); // Detener la recepción de cambios de red
        if (speedChecker != null) {
            speedChecker.stopChecking();
        }
        if (clientesAdapter != null) {
            clientesAdapter.clear();
        }
        if (clientesFiltrados != null) {
            clientesFiltrados.clear();
        }
        if (clientes != null) {
            clientes.clear();
        }
        WorkManager workManager = WorkManager.getInstance(requireContext());
        workManager.cancelAllWorkByTag("ClientesWorker");
    }
    private void checckBanderaPrestamos() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (PrestamosWorker.isTaskPrestamosCompleted) {
                isTableEmpty("avales", new IsTableEmptyCallback() {
                    @Override
                    public void onResult(boolean isAvalesEmpty) {
                        if (isAvalesEmpty) {
                            AvalesWorker.allDataLoadedAvales = false;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = false;
                            AvalesWorker.enqueueWork(requireContext());
                        } else {
                            AvalesWorker.allDataLoadedAvales = true;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = true;
                            //AvalesWorker.enqueueWork(requireContext());
                        }
                        checckBanderaAvales();
                    }
                });
            } else {
                Log.d("PRESTAMOS", "Tarea PRESTAMOS aún no completada. Reintentando en 500ms...");
                checckBanderaPrestamos(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }

    private void checckBanderaAvalesRefresh() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                Log.d("AvalesWorker", "Ambas tareas completadas. Ejecutando lógica de ejecutarLogicaClientes().......");
                ejecutarLogicaClientesRefresh();
            } else {
                Log.d("AvalesWorker", "Tarea avales aún no completadas. Reintentando en 500ms...");
                checckBanderaAvalesRefresh(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }

    private void checckBanderaAvales() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                Log.d("PRESTAMOS", "Ambas tareas completadas. Ejecutando lógica de ejecutarLogicaClientes().......");
                ejecutarLogicaClientes();
            } else {
                Log.d("PRESTAMOS", "Tarea avales aún no completadas. Reintentando en 500ms...");
                checckBanderaAvales(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }
    private void ejecutarLogicaClientesRefresh() {
        ClientesWorker.currentPageClientes = 0;
        ClientesWorker.allDataLoadedClientes = true;
        ClientesWorker.isTaskClientesCompleted = false;
        ClientesWorker.enqueueWork(requireContext());
        checkForUpdatesAndLoadCache();
        Log.d("PRESTAMOS", "Cargando desde caché, más de 2 registros.");
    }

    private void ejecutarLogicaClientes() {
        countClientesInSQLite(requireContext(), 2, new CountClientesCallback() {
            @Override
            public void onResult(boolean result) {
                // Si result es true, significa que hay menos de 2 registros en la tabla
                if (result) {
                    ClientesWorker.currentPageClientes = 0;
                    ClientesWorker.allDataLoadedClientes = false;
                    ClientesWorker.isTaskClientesCompleted = false;
                    ClientesWorker.enqueueWork(requireContext());
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            checkForUpdatesAndLoadCache();
                        }
                    }, 1000); // 4000 milisegundos = 4 segundos
                    Log.d("PRESTAMOS", "Cargando enqueueWork menos de 2 registros.");
                } else {
                    // Si result es false, significa que hay más de 2 registros

                    ClientesWorker.currentPageClientes = 0;
                    ClientesWorker.allDataLoadedClientes = true;
                    ClientesWorker.isTaskClientesCompleted = true;
                    //ClientesWorker.enqueueWork(requireContext());
                    checkForUpdatesAndLoadCache();
                    Log.d("PRESTAMOS", "Cargando desde caché, más de 2 registros.");
                }
            }
        });
    }

    private void cargarClientesDesdeSQLite(int offset, int batchSize) {
        List<Cliente> nuevosClientes = new ArrayList<>();
        mostrarPrimeros5Avales();
            // Lógica para cargar los datos desde SQLite
            DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            String query = "SELECT clientes.*, " +
                    "clientes.ruta_id as ruta_cliente, clientes.poblacion_id as poblacion_cliente, clientes.colocadora_id as colocadora_id, " +
                    "colocadoras.nombre_completo as nombre_colocadora, colocadoras.ruta_id as ruta_colocadora, colocadoras.poblacion_id as poblacion_colocadora, rutas.nombre_ruta, " +
                    "poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, " +
                    "MAX(prestamos.grupo_poblacion) as grupo_anterior, MAX(prestamos.fecha_prestamo) as fecha_prestamo, " +
                    "COUNT(prestamos.id) as cantidad_prestamos, " +
                    "avales_cliente.nombre_completo as nombre_aval, " +
                    "avales_cliente.direccion as direccion_aval, " +
                    "avales_cliente.telefono as telefono_aval, " +
                    "avales_cliente.otras_referencias as otras_referencias_aval, " +
                    "avales_cliente.garantias as garantias_aval, " +
                    "avales_cliente.update_comprobantes as update_comprobantes_aval, " +
                    "avales_cliente.update_garantias as update_garantias_aval " +
                    "FROM clientes " +
                    "LEFT JOIN prestamos ON prestamos.cliente_id = clientes.id " +
                    "LEFT JOIN avales as avales_cliente ON avales_cliente.id = clientes.aval_id " +
                    "INNER JOIN colocadoras ON colocadoras.id = clientes.colocadora_id " +
                    "INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                    "INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                    "LEFT JOIN avales ON avales.id = clientes.aval_id " +
                    "GROUP BY clientes.id " +
                    "ORDER BY clientes.updated_at DESC " +
                    "LIMIT ? OFFSET ?";

            Cursor cursor = db.rawQuery(query, new String[]{String.valueOf(batchSize), String.valueOf(offset)});

            if (cursor != null && cursor.moveToFirst()) {
                try {
                    do {
                        Cliente cliente = new Cliente(
                                cursor.getString(cursor.getColumnIndexOrThrow("id")),
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("direccion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("telefono")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("ruta_cliente")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("ruta_cliente")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("poblacion_cliente")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("poblacion_cliente")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("created_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("created_at")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("fecha_inicio")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_inicio")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("grupo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "Sin Aval",
                                cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("grupo_anterior")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo_anterior")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) : ""
                        );
                        nuevosClientes.add(cliente);
                    } while (cursor.moveToNext());
                } finally {
                    clientes.addAll(nuevosClientes); // Añadir todos los préstamos en lote

                    Log.d("PrestamosWorker", "Total de Clientes añadidos: " + nuevosClientes.size());
                    cursor.close(); // ASEGURAR QUE SE CIERRE EL CURSOR.
                }
            }
            db.close();


                if (getActivity() != null && isAdded() && isVisible() && recyclerView != null && recyclerView.getAdapter() != null) {
                    int totalClientes = nuevosClientes.size();
                    Log.d("ClientesFragment", "totalClientes Clientes para updateUIWithClientes." + totalClientes);
                    if (totalClientes >= 0) {
                        updateUIWithClientes(clientes);  // Actualiza la UI con la lista de clientes
                        isLoading = false;
                    } else {
                        Log.d("ClientesFragment", "No hay más Clientes para cargar.");
                    }
                }
                else
                {
                    Log.e("ClientesFragment", "ALGUN DARO ES NULO.................................................");
                }
    }


    private void loadMoreClientes() {
        if (!isLoading) {
            isLoading = true; // Marcar como cargando

            // Incrementar el offset para la próxima carga
            offset += BATCH_SIZE;

            // Llamar a la función para cargar más clientes desde SQLite
            cargarClientesDesdeSQLite(offset, BATCH_SIZE);
        }
    }

    private void countClientesInSQLite(Context context, int threshold, CountClientesCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            Log.d("SQLite", "Abriendo base de datos...");
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            int totalClientes; // Inicializamos el conteo

            // Consulta para contar los registros en la tabla "Clientes"
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM clientes", null);

            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    totalClientes = cursor.getInt(0); // Obtiene el conteo de la primera columna
                } else {
                    totalClientes = 0;
                }
                cursor.close(); // Cerrar el cursor
            } else {
                totalClientes = 0;
            }

            db.close(); // Cerrar la conexión a la base de datos

            Log.d("SQLite", "Total registros en SQLite CLIENTES: " + totalClientes);

            // Devolver el resultado al hilo principal
            if (callback != null) {
                // Usar runOnUiThread si estamos dentro de una Activity
                getActivity().runOnUiThread(() -> callback.onResult(totalClientes < threshold));
            }

            executor.shutdown();
        });
    }

    private interface CountClientesCallback {
        void onResult(boolean result);
    }

    // Método para verificar si la tabla está vacía
    private void isTableEmpty(String tableName, IsTableEmptyCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            boolean isEmpty = true;

            try {
                // Usar la base de datos según la tabla solicitada
                if (tableName.equalsIgnoreCase("avales")) {
                    db = new DatabaseHelper(requireContext()).getReadableDatabase();
                } else if (tableName.equalsIgnoreCase("prestamos")) {
                    db = new DatabaseHelper(requireContext()).getReadableDatabase();
                } else {
                    throw new IllegalArgumentException("Tabla desconocida: " + tableName);
                }

                // Consultar la tabla
                cursor = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
                if (cursor != null && cursor.moveToFirst()) {
                    isEmpty = cursor.getInt(0) == 0; // Vacía si el conteo es 0
                }
            } finally {
                executor.shutdown();
                if (cursor != null) cursor.close();
                if (db != null) db.close();
            }

            // Llamar al callback en el hilo principal
            boolean finalIsEmpty = isEmpty;
            getActivity().runOnUiThread(() -> {
                callback.onResult(finalIsEmpty);
            });
        });
    }

    public interface IsTableEmptyCallback {
        void onResult(boolean isEmpty);
    }

    private void checkForUpdatesAndLoadCache() {
        // Verificar si la tarea ya se completó
        if (ClientesWorker.isTaskClientesCompleted) {
            cargarClientesDesdeSQLite(offset, BATCH_SIZE);
            ClientesWorker.isTaskClientesCompleted = false; // Reiniciar la bandera
            retryCount = 0; // Reiniciar contador
        } else {
            // Si la tarea no se ha completado, reintentar
            if (retryCount < MAX_RETRIES) {
                retryCount++;
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    // Verificar si el fragmento sigue adjunto antes de intentar nuevamente
                    if (isAdded() && getContext() != null) {
                        checkForUpdatesAndLoadCache(); // Volver a intentar si sigue adjunto
                    } else {
                        Log.e("ClientesFragment", "El fragmento no está adjunto. Operación abortada.");
                        // Si no está adjunto, realiza la tarea sin interactuar con la UI del fragmento
                        // Por ejemplo, puedes realizar la tarea sin intentar actualizar la UI.
                        cargarClientesDesdeSQLite(offset, BATCH_SIZE);
                    }
                }, 4000); // Esperar 4 segundos antes de verificar nuevamente
            } else {
                Log.d("PRESTAMOS", "Número máximo de reintentos alcanzado. No se puede cargar la caché.");
                cargarClientesDesdeSQLite(offset, BATCH_SIZE);
                // Aquí puedes decidir qué hacer si no se completó la tarea después de varios intentos
            }
        }
    }


    public static void updateUIWithClientes(List<Cliente> clientes) {
            // Actualizar lista en el adaptador
            clientesAdapter.setListaFiltrada((ArrayList<Cliente>) clientes);

            // Notificar cambios en el adaptador
            clientesAdapter.notifyDataSetChanged();

            // Validar cambios
            //Log.d("ClientesFragment", "Clientes Adapter Data (después): " + clientesAdapter.getItemCount());

            // Asegurar que RecyclerView sea visible
            if (shimmer != null && shimmer.getVisibility() == View.VISIBLE) {
                Log.d("ClientesFragment", "Deteniendo el shimmer...");
                stopShimmer();
                isShimmerActive = false;
            }

            if (recyclerView != null) {
                recyclerView.setVisibility(View.VISIBLE);
            }

            // Ocultar el ProgressDialog
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
            }
    }

    private void mostrarPrimeros5Avales() {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT * FROM avales ORDER BY id DESC limit 5", null);

            Log.d("SQLite", "Mostrando los primeros 5 avales ordenados por ID:");
            while (cursor.moveToNext()) {
                int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                String nombre = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));
                String telefono = cursor.getString(cursor.getColumnIndexOrThrow("telefono"));
                String updatedAt = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));
                String direccion = cursor.getString(cursor.getColumnIndexOrThrow("direccion"));

                Log.d("SQLite", "ID Aval : " + id + ", Nombre: " + nombre + ", Teléfono: " + telefono + ", updatedAt: " + updatedAt + ", direccion: " + direccion);
            }
        } catch (Exception e) {
            Log.e("SQLite", "Error al obtener los primeros 5 avales", e);
        } finally {
            if (cursor != null) {
                cursor.close();
            }
            db.close();
        }
    }
    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                isFiltering = true;
                isLoading = true;

                dialog = new ProgressDialog(requireActivity(), R.style.AppMaterialAlertDialogStyle);
                dialog.setMessage("Cargando datos, por favor espere...");
                dialog.setCanceledOnTouchOutside(false);
                dialog.show();

                startShimmer();
                isShimmerActive = true;

                clientes.clear();
                clientesAdapter.clear();
                clientesAdapter.notifyDataSetChanged();

                retryCount=0;

                ClientesWorker.currentPageClientes = 0;
                ClientesWorker.allDataLoadedClientes = true;
                ClientesWorker.isTaskClientesCompleted = false;

                AvalesWorker.currentPageAvales = 0;
                AvalesWorker.allDataLoadedAvales = true;
                AvalesWorker.isTaskAvalesCompleted = false;


                Context context = getContext();
                if (context != null) {
                    Log.e("ClientesFragment", "Entro en ejecutar AvalesWorker.");
                    AvalesWorker.enqueueWork(context);
                    checckBanderaAvalesRefresh();
                } else {
                    Log.e("ClientesFragment", "El contexto es nulo. No se puede ejecutar AvalesWorker.");
                }


                filtrarClientes(ClientesFragment.svClientes.getQuery().toString());

                //getClientes();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void buscarClientes(String query) {
        Log.d("ClientesFragment", "ENTRO EN BUSCAR CLIENTES.........................................: ");

            if (isAdded() && getContext() != null) {
                DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
                SQLiteDatabase db = dbHelper.getReadableDatabase();

                Log.d("ClientesFragment", "Ejecutando búsqueda en la base de datos con query: " + query);

                String sqlQuery = "SELECT clientes.*, " +
                        "clientes.ruta_id as ruta_cliente, clientes.poblacion_id as poblacion_cliente, clientes.colocadora_id as colocadora_id, " +
                        "colocadoras.nombre_completo as nombre_colocadora, colocadoras.ruta_id as ruta_colocadora, colocadoras.poblacion_id as poblacion_colocadora, rutas.nombre_ruta, " +
                        "poblaciones.nombre_poblacion, poblaciones.fecha_inicio, poblaciones.grupo, " +
                        "MAX(prestamos.grupo_poblacion) as grupo_anterior, MAX(prestamos.fecha_prestamo) as fecha_prestamo, " +
                        "COUNT(prestamos.id) as cantidad_prestamos, " +
                        "COALESCE(avales_prestamo.nombre_completo, avales_cliente.nombre_completo, 'Sin Aval') as nombre_aval, " +
                        "COALESCE(avales_prestamo.direccion, avales_cliente.direccion, '') as direccion_aval, " +
                        "COALESCE(avales_prestamo.telefono, avales_cliente.telefono, '') as telefono_aval, " +
                        "COALESCE(avales_prestamo.otras_referencias, avales_cliente.otras_referencias, '') as otras_referencias_aval, " +
                        "COALESCE(avales_prestamo.garantias, avales_cliente.garantias, '') as garantias_aval, " +
                        "COALESCE(avales_prestamo.id, avales_cliente.id, NULL) as id_aval, " +
                        "COALESCE(avales_prestamo.update_comprobantes, avales_cliente.update_comprobantes, '') as update_comprobantes_aval, " +
                        "COALESCE(avales_prestamo.update_garantias, avales_cliente.update_garantias, '') as update_garantias_aval " +
                        "FROM clientes " +
                        "LEFT JOIN prestamos ON prestamos.cliente_id = clientes.id " +
                        "LEFT JOIN avales as avales_prestamo ON avales_prestamo.id = prestamos.aval_id " +
                        "LEFT JOIN avales as avales_cliente ON avales_cliente.id = clientes.aval_id " +
                        "INNER JOIN colocadoras ON colocadoras.id = clientes.colocadora_id " +
                        "INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                        "INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                        "LEFT JOIN avales ON avales.id = prestamos.aval_id " +
                        "WHERE clientes.nombre_completo LIKE ? OR avales.nombre_completo LIKE ? " + // Modificación aquí
                        "GROUP BY clientes.id " +
                        "ORDER BY clientes.id DESC ";

                Cursor cursor = db.rawQuery(sqlQuery, new String[]{"%" + query + "%", "%" + query + "%"});


                if (cursor != null && cursor.moveToFirst()) {
                    Log.d("ClientesFragment", "Clientes encontrados en la base de datos: " + cursor.getCount());

                    Set<String> idsEncontrados = new HashSet<>(); // Para evitar duplicados en memoria

                    do {
                        String clienteId = cursor.getString(cursor.getColumnIndexOrThrow("id"));

                        // Verificar si el cliente ya está en la lista
                        if (!idsEncontrados.contains(clienteId)) {
                            Cliente cliente = new Cliente(
                                    clienteId,
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("ruta_cliente")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("poblacion_cliente")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("created_at")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("updated_at")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("fecha_inicio")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("grupo")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("id_aval")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "Sin Aval",
                                    cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("prestanombre")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_garantias_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("update_comprobantes")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("grupo_anterior")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo"))
                            );

                            // Agregar cliente a la lista principal
                            clientes.add(cliente);
                            idsEncontrados.add(clienteId);

                            // Agregar cliente a la lista filtrada y actualizar UI
                            if (clientesFiltrados == null) {
                                clientesFiltrados = new ArrayList<>();
                            }
                            clientesFiltrados.add(cliente);
                            isFiltering = true;
                        }
                    } while (cursor.moveToNext());

                    cursor.close();
                } else {
                    Log.d("ClientesFragment", "No se encontraron clientes para la query: " + query);
                }

                db.close();

                // Actualizar la UI en el hilo principal
                getActivity().runOnUiThread(() -> {
                    if (clientesFiltrados != null) {
                        clientesAdapter.setListaFiltrada(clientesFiltrados);
                        clientesAdapter.notifyDataSetChanged();
                    }
                });
            }
    }

    public void filtrarClientes(String text) {
        Log.d("ClientesFragment", "Texto para filtrar: " + text);

        if (text.isEmpty()) {
            Log.d("ClientesFragment", "Texto vacío, restableciendo lista completa.");
            // Restablecer lista completa desde `clientes`
            clientesFiltrados = new ArrayList<>(clientes);
            isFiltering = false;
                clientesAdapter.setListaFiltrada(clientesFiltrados);
                clientesAdapter.notifyDataSetChanged();


        } else {
            // Filtrar en memoria
            Log.d("ClientesFragment", "Realizando filtrado en memoria.");
            Set<Cliente> uniqueClientesFiltrados = new HashSet<>();
            for (Cliente cliente : clientes) {
                String textoFiltro = cliente.getNombre_completo() + " " + cliente.getNombre_aval();
                if (textoFiltro.toLowerCase().contains(text.toLowerCase())) {
                    uniqueClientesFiltrados.add(cliente);
                }
            }

            // Actualizar lista filtrada
            clientesFiltrados = new ArrayList<>(uniqueClientesFiltrados);
            Log.d("ClientesFragment", "Clientes encontrados en memoria: " + clientesFiltrados.size());

            if (!clientesFiltrados.isEmpty()) {
                // Si hay coincidencias en memoria, actualiza el adaptador
                isFiltering = true;
                    clientesAdapter.setListaFiltrada(clientesFiltrados);
                    clientesAdapter.notifyDataSetChanged();

            } else {
                // Si no hay coincidencias en memoria, buscar en la base de datos
                Log.d("ClientesFragment", "No se encontraron coincidencias en memoria. Buscando en SQLite.");
                buscarClientes(text); // Llamar a la función de búsqueda
            }
        }
    }

    // Método para verificar la conectividad de red
    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager) requireContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }



    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;

        if (speedChecker == null) {
             // Obtener referencia al TextView
            speedChecker = new NetworkSpeedChecker(requireActivity(), textViewMensajes);
        }
        if (isConnected) {
            speedChecker.startChecking();
            //ClientesWorker.isTaskClientesCompleted = false;
            //ClientesWorker.enqueueWork(getContext());
            //checkForUpdatesAndLoadCache();
            if (textViewMensajes != null) {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("");
            }
        } else {
            if (textViewMensajes != null) {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("¡SIN INTERNET!");
                stopShimmer();
                // Mostrar el RecyclerView
                recyclerView.setVisibility(View.VISIBLE);
            }
            if (speedChecker != null) {
                speedChecker.stopChecking();
                stopShimmer();
                // Mostrar el RecyclerView
                recyclerView.setVisibility(View.VISIBLE);
            }
        }
        if (sesion.getString("nombre_perfil", "").equals("COBRADOR") || sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            if (isConnected) {
                // Ocultar el textViewMensajes si está visible
                hideTextViewAfterDelay();
                //getPrestamos(modalidad_id); // Verificar actualizaciones en lugar de cargar nuevo lote
            }
        }
    }
    private void hideTextViewAfterDelay() {
        if (textViewMensajes != null && textViewMensajes.getVisibility() == View.VISIBLE) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("");
            }, 3000);
        }
    }

    private void getColocadoras() {
        if (colocadoraController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlColocadoras, data,
                    response -> {
                        try {
                            JSONArray data1 = (JSONArray) response.get("data");

                            for (int i = 0; i < data1.length(); i++) {
                                JSONObject obj = data1.getJSONObject(i);

                                Gson gson = new Gson();
                                Colocadora colocadora = gson.fromJson(obj.toString(), Colocadora.class);

                                colocadoras.add(colocadora);
                                colocadoraController.nueva(colocadora);
                            }
                            Log.d("Colocadoras", "Registros insertados en colocadoras: " + colocadoras.size());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }, error -> ErrorChecker.checker(error, requireActivity()));

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            colocadoras = colocadoraController.obtener();
        }
    }

    private void getRutas() {
        if (rutaController.obtener().size() == 0) {
            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    response -> {
                        try {

                            JSONArray data1 = (JSONArray) response.get("data");

                            for (int i = 0; i < data1.length(); i++) {

                                JSONObject obj = data1.getJSONObject(i);

                                Gson gson = new Gson();
                                Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                rutas.add(ruta);
                                rutaController.nueva(ruta);

                            }
                            Log.d("Rutas", "Registros insertados en rutas: " + rutas.size());

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }, error -> ErrorChecker.checker(error, requireActivity()));

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        } else {
        }
    }

    private void getPoblaciones() {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    response -> {
                        try {

                            JSONArray data1 = (JSONArray) response.get("data");

                            for (int i = 0; i < data1.length(); i++) {

                                JSONObject obj = data1.getJSONObject(i);

                                Gson gson = new Gson();
                                Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                poblaciones.add(poblacion);
                                poblacionController.nueva(poblacion);

                            }
                            Log.d("Poblaciones", "Registros insertados en poblaciones: " + poblaciones.size());  // Loguea la cantidad de registros insertados

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }, error -> ErrorChecker.checker(error, requireActivity()));

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            poblaciones = poblacionController.obtener();
        }
    }
}